<?php
// log_ring.php - tar emot JSON och loggar till en textfil (append)

// Returnera alltid JSON
header('Content-Type: application/json; charset=utf-8');

// Tillåt bara POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  echo json_encode(["ok" => false, "error" => "Method not allowed"]);
  exit;
}

// Hemlig nyckel (BYT!)
$secret = '1234567890';

// Läs body
$raw = file_get_contents('php://input');
$data = json_decode($raw, true);

if (!is_array($data)) {
  http_response_code(400);
  echo json_encode(["ok" => false, "error" => "Bad JSON"]);
  exit;
}

// Kontrollera nyckel
$key = isset($data['key']) ? (string)$data['key'] : '';
if (!hash_equals($secret, $key)) {
  http_response_code(403);
  echo json_encode(["ok" => false, "error" => "Forbidden"]);
  exit;
}

// Plocka ut data
$topic   = isset($data['topic']) ? trim((string)$data['topic']) : '';
$event   = isset($data['event']) ? trim((string)$data['event']) : 'message';
$msg     = isset($data['message']) ? trim((string)$data['message']) : '';
$timeIso = isset($data['time_iso']) ? trim((string)$data['time_iso']) : date('c');

// IP (valfritt)
$ip = $_SERVER['REMOTE_ADDR'] ?? '';

// Sanera radbrytningar
$msg = str_replace(["\r", "\n"], [" ", " "], $msg);

// Loggfil
$logDir  = __DIR__ . '/logs';
$logFile = $logDir . '/ringklocka.log';

if (!is_dir($logDir)) {
  mkdir($logDir, 0750, true);
}

// Format: [ISO8601]  topic  event  ip  message
$line = sprintf("[%s]\t%s\t%s\t%s\t%s\n", $timeIso, $topic, $event, $ip, $msg);

// Append med fil-lås
file_put_contents($logFile, $line, FILE_APPEND | LOCK_EX);

echo json_encode(["ok" => true]);
